############################## Probabilities #############################

################################################# set 'working Directory'
setwd("D:/AS17 translation/AS17 supplements")
opar <- par() 
##########################################################################
#                            Data / Sources
# source("Vickers function.r")
##########################################################################

                                                           # Section 4.3.1
                                                        
                                                          # example bridge 
P.A1 <- choose(4,1)*choose(48, 12) / choose(52, 13); P.A1
P.A2 <- choose(3,1)*choose(36, 12) / choose(39, 13); P.A2
P.A3 <- choose(2,1)*choose(24, 12) / choose(26, 13); P.A3
P.A4 <- 1
P.A1 * P.A2 * P.A3 * P.A4

##########################################################################

                                                           # Section 4.3.2

                                                       # birthday promblem

k <- 24;  p <- numeric(k)                              # number of Persons
for (i in 1:k)      {
  q <- 1 - (0:(i - 1))/365                             # no agreement
  p[i] <- 1 - prod(q)  }

par(mfcol=c(1,1), lwd=2, font.axis=2, bty="l", ps=18) 
plot(2:k, p[2:k], xaxp=c(2, k, (k-2)/2), las=1, pch=16, cex=1.3,
     xlab ="Number of persons", ylab = "Probability", col="blue")
abline(h=0.5, col="red", lty=2)
abline(h=seq(0,0.45,0.05), col="grey", lty=3)

                                                                   # table
qbirthday(prob = 0.5, classes = 365, coincident = 2)
qbirthday(prob = 0.5, classes = 365, coincident = 3)
qbirthday(prob = 0.5, classes = 365, coincident = 4)
qbirthday(prob = 0.5, classes = 365, coincident = 5)
qbirthday(prob = 0.5, classes = 365, coincident = 6)
qbirthday(prob = 0.5, classes = 365, coincident = 7)
qbirthday(prob = 0.5, classes = 365, coincident = 8)

##########################################################################

                                                             # Section 4.5

sens <- 0.99                                                 # sensitivity        
spez <- 0.97                                                 # specifity          
prev <- seq(0, 1, by=0.01)                                   # prevalence          

ppw  <- (sens * prev) / (sens * prev + (1 - spez) * (1 - prev))
npw  <- (spez * (1 - prev)) / (spez * (1 - prev) + (1 - sens) * prev)

                                                              # figure 4.8
par(mfcol=c(1,1), lwd=2, font.axis=2, bty="l", ps=16,
    cex.axis=1.0, cex.lab=1.3)
plot(prev, ppw, type="l", col="red",   xlab="prevalence", las=1,
    ylab="positive/negative predictive value", lty=1, lwd=2.7)
lines(prev, npw, col="blue", lty=2, lwd=2.7)
legend(0.2, 0.5, c("predictive value of a positive test",
                   "predictive value of a negative test"), cex=1.3,
       col=c("red", "blue"), bty="n", lty=c(1,2))

##########################################################################
                                            
                                                               # screening
pfn <- function(n, prev, sens, spec=1) { 
  npv <- (1-prev)*spec / ((1-prev)*spec + prev*(1-sens))
  p   <- 1- npv^n; return(round(100*p, 1))  }

pfn(n=c(1000, 5000), prev=0.01, sens=0.95, spec=1.00)
pfn(n=c(1000, 5000), prev=0.01, sens=0.95, spec=0.90)

                                                             # table 4.8
ni    <- c(500, 1000, 2000, 5000)
previ <- c(0.02, 0.01)
sensi <- c(0.90, 0.95, 0.99)
tab <- matrix(rep(NA, 36), nrow=6, byrow=T)
k   <- 0
for (i in 1:3) {
  for (j in 1:2) {
    k <- k + 1
    tab[k,] <- c(sensi[i], previ[j],pfn(ni, previ[j], sensi[i], spec=1)) 
  } }

colnames(tab) <- c("sensitivity","prevalence","500","1000","2000","5000")
tab

##########################################################################

                                                           # Section 4.5.1

library(rms)
library(Hmisc)
                                                # fasting blood sugar data           
blz.diab <- c( 
 119,  89, 136,  89, 107, 137, 126, 101, 105, 134, 131, 133, 117, 102, 108, 112,  94,  90,
 102,  74, 119, 130, 105, 111, 130, 114, 110, 124,  71, 138,  96, 112, 121, 124, 102, 109,
 108, 130,  89, 114, 153, 109, 103,  77, 133, 122,  87, 102, 130, 120, 118, 100, 114, 138,
 136, 111, 100, 100, 118, 127, 105, 126, 127,  81, 117, 104, 105,  84, 149, 132, 104, 114,
 116, 142, 110, 139, 131, 120, 114, 156, 106, 112, 125, 112,  89, 143, 108, 133, 139, 116,
 115, 149,  94, 128,  80, 119, 122, 148, 117, 135)
blz.cntr <- c(
  93,  78,  42,  70, 109,  75,  80,  73, 115, 100,  60,  58,  70,  53,  94,  80,  71,  95,
  71, 127,  66,  75,  68,  92,  66, 108, 117,  41,  80,  71,  86,  68,  75,  87, 110, 104,
  53,  82, 120,  89,  77,  77,  78,  52,  65, 101,  69,  53,  61,  99,  73,  89, 102,  78,
 110, 113, 143,  73,  87,  88,  76,  90,  75, 102,  60,  62, 115,  69, 113,  97,  78,  98,
  62,  86,  81,  96,  61,  60,  91,  98,  94,  87,  59,  94,  47,  95,  80, 114,  74,  73,
  55,  85,  91,  85,  31,  84, 106,  91,  65,  84)

                                                             #  figure 4.9
par(mfcol=c(1,1),lwd=2, font.axis=2, bty="n", ps=12, las=0, col="black")
#options(digits=0); 
out <- histbackback(blz.diab, blz.cntr, brks=seq(30, 170, by=10), 
                    axes=TRUE, las=1, cex.axis=1.5,
                    xlab=c("diabetics", "controls"), 
                    ylab="Fasting blood sugar [mg/dl]")
barplot(-out$left, col="coral" , horiz=TRUE, space=0, add=TRUE, axes=FALSE)
barplot(out$right, col="cyan", horiz=TRUE, space=0, add=TRUE, axes=FALSE)
abline(h=7, col="red", lwd=4, lty=2)

##########################################################################
                                                  
library(ROCR)                                               #  figure 4.10
blz <- c(blz.diab, blz.cntr)
grp <-  c(rep(1, length(blz.diab)), rep(0, length(blz.cntr)))
pred <- prediction(blz, grp)

roc <- performance(pred,"tpr","fpr")

par(mfcol=c(1,1),lwd=2, font.axis=2, bty="n", ps=14, las=1)   
plot(roc, xlab="1 - Specificity", ylab="Sensitivity")
abline(0,1);    abline(0.65, 1, lty=2.5, col="red")
points(0.19, 0.85, pch=16, cex=1.5, col="red")
text(0.3, 0.75, "Sens.: 85%"); text(0.3, 0.65, "Spez.: 81%")
text(0.6, 0.20, "AUC: 0.885"); text(0.1, 0.920, "100 mg/dl")

##########################################################################

                                                         # Fagan nomogramm
library(UncertainInterval)
par(opar)                                                    # figure 4.11
nomogram(prob.pre.test = .80, LR=c(pos=2.5, neg=NULL))

##########################################################################

                                                           # Section 4.5.3

                                             # decision analysis (Vickers)
source("Vickers function.r")
blz.diab <- c( 
  119,  89, 136,  89, 107, 137, 126, 101, 105, 134, 131, 133, 117, 102, 108, 112,  94,  90,
  102,  74, 119, 130, 105, 111, 130, 114, 110, 124,  71, 138,  96, 112, 121, 124, 102, 109,
  108, 130,  89, 114, 153, 109, 103,  77, 133, 122,  87, 102, 130, 120, 118, 100, 114, 138,
  136, 111, 100, 100, 118, 127, 105, 126, 127,  81, 117, 104, 105,  84, 149, 132, 104, 114,
  116, 142, 110, 139, 131, 120, 114, 156, 106, 112, 125, 112,  89, 143, 108, 133, 139, 116,
  115, 149,  94, 128,  80, 119, 122, 148, 117, 135)
blz.cntr <- c(
  93,  78,  42,  70, 109,  75,  80,  73, 115, 100,  60,  58,  70,  53,  94,  80,  71,  95,
  71, 127,  66,  75,  68,  92,  66, 108, 117,  41,  80,  71,  86,  68,  75,  87, 110, 104,
  53,  82, 120,  89,  77,  77,  78,  52,  65, 101,  69,  53,  61,  99,  73,  89, 102,  78,
  110, 113, 143,  73,  87,  88,  76,  90,  75, 102,  60,  62, 115,  69, 113,  97,  78,  98,
  62,  86,  81,  96,  61,  60,  91,  98,  94,  87,  59,  94,  47,  95,  80, 114,  74,  73,
  55,  85,  91,  85,  31,  84, 106,  91,  65,  84)

marker   <- c(blz.diab, blz.cntr)
postest  <- marker>100
diabetes <- c(rep(1, 100), rep(0,100))
                                                             # figure 4.12
dcav(yvar=diabetes, xmatrix=postest, prob=c("Y"), ymax=0.60)
sens <- 0.85; spec <- 0.81; prev <- 0.50
p_t <- seq(0, 1, by=0.01)
n_b <- prev * sens - (1-prev) *(1-spec) * (p_t/(1-p_t))
tempnb <- prev - (1-prev) * p_t / (1 - p_t)
                                                    
par(mfcol=c(1,1),lwd=2, font.axis=2, bty="n", 
    cex.axis=1.2, cex.lab=1.4, ps=14, las=0, col="black")
plot(p_t, n_b, type="l", ylim=c(-0.1, prev+0.01), 
     xlim=c(0,1), lty=1, las=1, col="black", 
     ylab="Benefit (possible) ", xlab="Decision threshold")
abline(h=0, lty=2, col="darkgrey")
lines(p_t, tempnb, lty = 3, col="darkgrey")
legendlabel <- c("model","null","all")
legendcolor <- c("black","darkgrey","darkgrey")
legendpattern <- c(1,2,3)
legend("topright", legendlabel, cex=0.9, bty="n", 
                  col=legendcolor, lty=legendpattern)

##########################################################################
